# -*- coding: utf-8 -*-
"""
Created on Thu Sep 12 14:20:27 2019

@author: warby
"""
#import argparse
import os
import pandas as pd
import numpy as np
import matplotlib.pyplot as plt
#Physical Constants

h = 6.626070040e-34; # Planck in J s
c = 299792458; # speed of light in m s-1
q = 1.6021766208e-19; # elementary charge in C
#def get_args():
#    """Get arguments and options"""
#    parser = argparse.ArgumentParser(description='Calculation of EL quantum efficiency and Photometric Values.')
#
#    parser.add_argument_group('Select directory and sprectrum file')
#    parser.add_argument('-d', '--directory', type=str, help="Path to you data folder (e.g. 'C:/folder_name/sub_folder/short_name_in.txt'")    
#    parser.add_argument('-sf', '--sprectrum_file',type=str, help="Path to your spectrum file (e.g. 'C:/folder_name/sub_folder/spectrum_file.txt")
#    
#    parser.add_argument_group('Select EL range ')
#
#    opt = parser.add_argument_group('optional arguments', gooey_options={'columns': 2})
#    opt.add_argument('-lr', '--laser_range', nargs = 2, default = "395 410", type=int, help="Laser wavelength range in nm, Default = 395 410")
#    opt.add_argument('-plr', '--pl_range', nargs = 2, default = "550 850", type=int, help="PL detection range in nm, Default = 550 850")
#    opt.add_argument('-cfg', '--config', default='Maya red', widget="Dropdown", choices=cfgs, type=str, help="Fiber and spectrometer configurations. Choices: 'Maya red', 'Maya steel', 'QE red 25', 'QE red 200', 'QE steel 25' or 'QE steel 200', Default = 'Maya red'")    
#    opt.add_argument('-sl', '--stray_light', action='store_true', help="Removes stray light background. Default = 'False'")
#    opt.add_argument('-cb', '--common_bckg', default= 'bckg.txt', type=str, help=" Name of the common background file. Default = 'bckg.txt'")
#    opt.add_argument('-ce', '--common_empty', default= 'empty.txt', type=str, help=" Name of the common empty file. Default = 'empty.txt'")
#
#   
#
#    args = parser.parse_args()
#
#    args.directory = Path(args.short_path).resolve().parent
#    args.short_name = Path(args.short_path).name
#    if (args.long_path != '') : args.long_name = Path(args.long_path).name
#    args.cwd = Path.cwd()
#    return args
#Device Parameters
device_area= 0.09 #device area in cm2
spectrum_data = np.genfromtxt('PeLEDspectrum.csv', delimiter=',', skip_header=1) #the EL emission spectrum of your device
data_folder_name = "data"#the folder which your data is in
min_lambda = 450
max_lambda = 650
luminescence_range = np.arange(min_lambda , max_lambda, 1)
rad_flux_threshold = 1e-9


#Calculation of geometrical configuration factor

W1 = 3 #the width of your LED pixel in mm (should always be 3)
W2 = 10 #the width of the photodiode in mm (should always be 10)
H = 9 #the distance between the LED and the photodiode in mm (measured to be 9)

def CF(w1,w2,H):
    w1 = W1 / H
    w2 = W2 / H
    x = w2 - w1
    y = w2 + w1

    p = (w1**2 + w2**2 +2)**2
    q = (x**2 + 2) * (y**2 + 2)
    u = np.sqrt(x**2 + 4)
    v = np.sqrt(y**2 + 4)

    s = u * ( x * np.arctan(x/u) - y * np.arctan(y/u) )
    t = v * ( x * np.arctan(x/v) - y * np.arctan(y/v) )
    
    F12 = 1 / (np.pi *  w1**2) * (np.log(p/q) + s - t)
    
    return F12

F12 = CF(W1,W2,H)
#Measurement Parameters
geometry_cf = F12 #configuration factor for portion of photons which land on photodiode

#####################################################################################################################################

#Generating Photodiode correction factor data from PD responsivity and LED spectrum
responsivity_data = np.genfromtxt('FDS1010responsivity.csv', delimiter=',', skip_header=1) #Responsivity data for photodiode
x1 = responsivity_data[:,0]
y1 = responsivity_data[:,1]
x2 = spectrum_data[:,1]
y2 = spectrum_data[:,0]


#interpolate data every nm
y1interp = np.interp(luminescence_range, x1, y1)#interpolated values of reponsivity of photodiode
responsivity = y1interp
y2interp = np.interp(luminescence_range, x2, y2)#interpolated values of spectrum

#normalised spectrum proportional to Watts
spectruminwatts = y2interp
spectrumpropwatts = spectruminwatts / max(spectruminwatts)
integralspectrumpropwatts = np.trapz(spectrumpropwatts,luminescence_range)
#convert responsivity in A/W into EQE in electrons/photon
photonperjoule = 1/((h*c)/(luminescence_range * 1e-9)) #photons per joule at a given wavelength
electronsperamp = 1/q
EQEconv = electronsperamp/photonperjoule
EQE = y1interp * EQEconv

#convert spectrum from something that is proportional to W/nm to something that is proportional to photons/nm, plot result
photoncorrectedspectrum = spectruminwatts * luminescence_range
photoncorrectedspectrum = photoncorrectedspectrum / max(photoncorrectedspectrum)

#create emission weighted EQE, plot result, generate correction factor (in electrons/photon) 
emissionweightedEQE = EQE*photoncorrectedspectrum #EQE is electrons/photon and we have 
integralemissiontimesEQE = np.trapz(emissionweightedEQE,luminescence_range)
integralphotoncorrectedspectrum =np.trapz(photoncorrectedspectrum,luminescence_range)
PD_cf = integralemissiontimesEQE / integralphotoncorrectedspectrum #this correction factor tells us what fraction of photons that reach the photodiode are converted into measured electrons

#Create emission weighted responsivity
emissionweightedresponsivity = responsivity * photoncorrectedspectrum
integralemissiontimesresponsivity = np.trapz(emissionweightedresponsivity,luminescence_range)
responsivity_cf = integralemissiontimesresponsivity / integralphotoncorrectedspectrum

data_folder_location = data_folder_name + os.sep # os.sep is a function which introduces the operating systems directory separater
wd = os.getcwd() + os.sep + data_folder_location + os.sep#get current working directory and add the data folder name to it so we can access the data
files = [f for f in os.listdir(wd) if (f.endswith('.ilv'))]#create a list of the files in the working directory ending in .ilv these are our current, voltage and EQE values 
for file in files: 
    f = pd.read_csv(wd + file, sep = '\t')
    f= f.drop(['Radiance [W/sr/m2]',	'Luminant Flux [lm]',	'Luminant int [cd]',	'Luminance [cd/m2]',	'EQE [%]',	'Curr. efficiency [cd/A]',	'Wall plug [W/W]',	'Luminous efficacy [lm/W]'], axis=1)
    
    f['Radiant Flux [W]'] = (f['PD current [A]']/(geometry_cf * responsivity_cf))
    f['Radiant Intensity[W / sr]'] = f['Radiant Flux [W]'] / np.pi
    f['Radiance [W/sr/m2]'] = f['Radiant Intensity[W / sr]'] / (device_area * 1E-4)
    
    #interpolate luminosity functions
    #CIE1924 - standard - report this
    luminosity_1924_data = np.genfromtxt('CIE1924Luminosity.csv', delimiter=',')
    x3 = luminosity_1924_data[:,0]
    y3 = luminosity_1924_data[:,1]
    y3interp = np.interp(luminescence_range, x3, y3)
    CIE1924 = y3interp
    #Judd - Voss 1978 - more accurate for red and especially blue
    luminosity_1978_data = np.genfromtxt('Judd-Voss1978Luminosity.csv', delimiter=',') 
    x4 = luminosity_1978_data[:,0]
    y4 = luminosity_1978_data[:,1]    
    y4interp = np.interp(luminescence_range, x4, y4)
    JuddVoss1978 = y4interp    
    
    #calculating photometric values
    photometricconversion = ((683* CIE1924 * spectrumpropwatts) * (1/integralspectrumpropwatts))
    integralphotometricconversion = np.trapz(photometricconversion, luminescence_range)
    
    f['Luminant Flux [lm]'] = f['Radiant Flux [W]'] * integralphotometricconversion
    f['Luminant Intensity [cd]'] = f['Luminant Flux [lm]'] / np.pi
    f['Luminance [cd/m2]'] = f['Luminant Intensity [cd]'] / (device_area * 1E-4)
    
    #calculating efficiencies
    f['EQE [%]'] = 100*((f['PD current [A]'])/(geometry_cf * PD_cf))/((f['LED current [mA/cm2]']*device_area)/1000)
    f['Current efficiency [cd/A]'] = f['Luminant Intensity [cd]'] / (f['LED current [mA/cm2]'] * device_area / 1000 ) 
    f['Luminous efficacy [lm/W]'] = f['Luminant Flux [lm]'] /((f['LED current [mA/cm2]'] * device_area / 1000 ) * f['LED voltage [V]'])
    f['Wall plug efficiency [W/W]'] = f['Radiant Flux [W]'] / ((f['LED current [mA/cm2]'] * device_area / 1000 ) * f['LED voltage [V]'])
    
    #setting a threshold for radiant flux so efficiency = 0 when there is no light and only noise
    f['EQE [%]'] = np.where(f['Radiant Flux [W]']< rad_flux_threshold,0,f['EQE [%]'])
    f['Current efficiency [cd/A]'] = np.where(f['Radiant Flux [W]']< rad_flux_threshold,0,f['Current efficiency [cd/A]'])
    f['Luminous efficacy [lm/W]'] = np.where(f['Radiant Flux [W]']< rad_flux_threshold,0,f['Luminous efficacy [lm/W]'])
    f['Wall plug efficiency [W/W]'] = np.where(f['Radiant Flux [W]']< rad_flux_threshold,0,f['Wall plug efficiency [W/W]'])
    
    #publish new file
    f.to_csv(wd+ file + '_processed')
plt.semilogy(luminescence_range, spectrumpropwatts)

 